function BinData(rootDir, NTrialTypes, Bins)
%This Function will create and Excel output tables
% This code uses parts of the v3 script written by Elan.
%Created by Lukasz Piszczek
%Last Update: 12/12/2014 


dirListing = dir(rootDir); 
NTrialTypes = NTrialTypes;
% Add headers to Trial by Trial Table

HeadersSummary = {'File ID','Animal ID','Session ID','End Position','Group','Trial Type','Premature pokes','Precue response rate','Response port Pokes in Cue','Latency to poke in Cue','Total Trials Finished','% of Correct GO trials/False alarms trials with premature','% of Correct GO trials/False alarms trials excluding premature','Reward Port Total licks in Reward','Response port pokes in Precue','Response Port pokes in Cue','Response Port pokes in Reward','Response Port Total pokes in ITI','Response port total pokes','Reward port Total pokes Precue','Reward port Total pokes Cue','Reward port Total pokes Reward','Reward port Total pokes ITI','Reward port total pokes', 'Latency in Poked Trials'};

FilesFound = length(dirListing)-2;
SummaryxlsTable = HeadersSummary;

for i = 1:length(dirListing)
    if(strcmp(dirListing(i).name,'.') || strcmp(dirListing(i).name,'..') || dirListing(i).isdir) 
        continue;
    else 
        isResult = regexp(dirListing(i).name, '.*\.mat$');
        if ( ~isempty(isResult) )
            resultFile = dirListing(i).name();
            [SummaryTableBins] = BinningSingleFile([rootDir '\' resultFile], Bins);
            SummaryxlsTable= [SummaryxlsTable; SummaryTableBins];
        end
    end  
end

     
            
% Write the Summary table as xls file            
if exist([rootDir '\' 'SummaryTableBins.xls'])==2
   delete([rootDir '\' 'SummaryTableBins.xls']);
end             
xlswrite([rootDir '\' 'SummaryTableBins.xls'], SummaryxlsTable)           
         
end
